/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.link;

import com.ibm.hwmca.base.custinfo.CustomerInfoData;
import com.ibm.hwmca.base.custinfo.CustomerInfoManager;
import com.ibm.hwmca.fw.rcs.PathManager;
import com.ibm.hwmca.fw.rcs.RcsConfig;
import com.ibm.hwmca.fw.rcs.RcsControl;
import com.ibm.hwmca.fw.rcs.conndata.ConnectionInfoManager;
import com.ibm.hwmca.fw.rcs.conndata.ConnectivityInfo;
import com.ibm.hwmca.fw.rcs.conndata.PassthruInfo;
import com.ibm.hwmca.fw.rcs.conndata.ServerInfo;
import com.ibm.hwmca.fw.rcs.link.L2tpLink;
import com.ibm.hwmca.fw.rcs.link.LinkAlreadyActiveException;
import com.ibm.hwmca.fw.rcs.link.LinkFailedException;
import com.ibm.hwmca.fw.rcs.link.LinkNotConfiguredException;
import com.ibm.hwmca.fw.rcs.link.RcsLink;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigData;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigManager;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Iterator;

public class L2tpVpnLink
extends L2tpLink {
    private static final String TRACE_MASKT = "XRCSLVLT";
    private static final String TRACE_MASKF = "XRCSLVLF";
    private static final String TRACE_MASKD = "XRCSLVLD";
    private static L2tpVpnLink instance;
    public boolean failOver;

    protected L2tpVpnLink() {
        this.maxOpenPaths = 5;
        this.highPerformance = true;
        Trace.trace(TRACE_MASKT, "<-> L2tpVpnLink()");
    }

    public static RcsLink getInstance() {
        if (instance == null) {
            instance = new L2tpVpnLink();
        }
        Trace.trace(TRACE_MASKT, "<-> getInstance() [" + instance + "]");
        return instance;
    }

    public void activate() throws LinkAlreadyActiveException, LinkFailedException, LinkNotConfiguredException {
        Trace.trace(TRACE_MASKT, "--> activate()");
        if (this.active) {
            this.deactivate();
        }
        if (!this.isConfigured()) {
            throw new LinkNotConfiguredException();
        }
        try {
            int rc = 0;
            OutboundConfigData outConfig = OutboundConfigManager.getOutboundConfigManager().getOutboundConfig();
            Iterator i = outConfig.getPassthruInfo().iterator();
            while (i.hasNext()) {
                String ursfServer;
                String sasServer;
                String sdrServer;
                String rs3Port;
                String rs3Server;
                String vpnServer;
                ServerInfo serverInfo;
                ConnectivityInfo connData;
                String region;
                String country;
                CustomerInfoData custData;
                PassthruInfo pInfo = (PassthruInfo)i.next();
                String ip = pInfo.getIpAddress();
                RcsConfig cfg = RcsConfig.getRcsConfig();
                cfg.setTemporaryConfigValue("l2tp_remote_host", ip);
                if (!this.failOver) {
                    PathManager.getPathManager().setSdc(1);
                    custData = CustomerInfoManager.getCustomerInfoManager().getCustomerInfo();
                    country = custData.getSystemCountryCode();
                    region = custData.getSystemSubdivisionCode();
                    connData = ConnectionInfoManager.getConnectionInfoManager().getConnectivityInfo(country, region);
                    serverInfo = connData.getServerInfo("Server_VPN");
                    vpnServer = serverInfo == null ? "" : serverInfo.getIpAddress();
                    serverInfo = connData.getServerInfo("Server_RS3");
                    rs3Server = serverInfo == null ? "" : serverInfo.getIpAddress();
                    rs3Port = serverInfo == null ? "" : String.valueOf(serverInfo.getPort());
                    serverInfo = connData.getServerInfo("Server_SA");
                    sdrServer = serverInfo == null ? "" : serverInfo.getIpAddress();
                    serverInfo = connData.getServerInfo("Server_SAS");
                    sasServer = serverInfo == null ? "" : serverInfo.getIpAddress();
                    serverInfo = connData.getServerInfo("Server_URSF");
                    ursfServer = serverInfo == null ? "" : serverInfo.getIpAddress();
                    cfg.setTemporaryConfigValue("vpn_server", vpnServer);
                    cfg.setTemporaryConfigValue("host_rs3", rs3Server);
                    cfg.setTemporaryConfigValue("port_rs3", rs3Port);
                    cfg.setTemporaryConfigValue("host_sdr", sdrServer);
                    cfg.setTemporaryConfigValue("host_sas", sasServer);
                    cfg.setTemporaryConfigValue("host_ursf", ursfServer);
                    if (PathManager.getPathManager().isRemoteServiceCall() && !vpnServer.equals("207.25.252.196")) continue;
                    rc = vpnServer.equals("207.25.252.196") ? RcsControl.startRemVpn() : RcsControl.startRemVpnBkp();
                    if (rc == 0) {
                        this.active = true;
                        break;
                    }
                }
                PathManager.getPathManager().setSdc(2);
                custData = CustomerInfoManager.getCustomerInfoManager().getCustomerInfo();
                country = custData.getSystemCountryCode();
                region = custData.getSystemSubdivisionCode();
                connData = ConnectionInfoManager.getConnectionInfoManager().getConnectivityInfo(country, region);
                serverInfo = connData.getServerInfo("Server_VPN");
                vpnServer = serverInfo == null ? "" : serverInfo.getIpAddress();
                serverInfo = connData.getServerInfo("Server_RS3");
                rs3Server = serverInfo == null ? "" : serverInfo.getIpAddress();
                rs3Port = serverInfo == null ? "" : String.valueOf(serverInfo.getPort());
                serverInfo = connData.getServerInfo("Server_SA");
                sdrServer = serverInfo == null ? "" : serverInfo.getIpAddress();
                serverInfo = connData.getServerInfo("Server_SAS");
                sasServer = serverInfo == null ? "" : serverInfo.getIpAddress();
                serverInfo = connData.getServerInfo("Server_URSF");
                ursfServer = serverInfo == null ? "" : serverInfo.getIpAddress();
                cfg.setTemporaryConfigValue("vpn_server", vpnServer);
                cfg.setTemporaryConfigValue("host_rs3", rs3Server);
                cfg.setTemporaryConfigValue("port_rs3", rs3Port);
                cfg.setTemporaryConfigValue("host_sdr", sdrServer);
                cfg.setTemporaryConfigValue("host_sas", sasServer);
                cfg.setTemporaryConfigValue("host_ursf", ursfServer);
                rc = vpnServer.equals("207.25.252.196") ? RcsControl.startRemVpn() : RcsControl.startRemVpnBkp();
                if (rc != 0) continue;
                this.active = true;
                break;
            }
            if (!this.active) {
                throw new LinkFailedException("Failed to remote vpn (RC: " + rc + ")");
            }
        }
        catch (LinkFailedException e) {
            throw e;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e);
        }
        Trace.trace(TRACE_MASKT, "<-- activate()");
    }

    public void deactivate() {
        Trace.trace(TRACE_MASKT, "--> deactivate()");
        PathManager.getPathManager().setRemoteServiceCall(false);
        try {
            RcsControl.stopRemVpn();
            RcsControl.stopRemVpnBkp();
            this.active = false;
            this.failOver = false;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e);
        }
        Trace.trace(TRACE_MASKT, "<-- deactivate()");
    }

    public boolean isConfigured() {
        OutboundConfigData data = OutboundConfigManager.getOutboundConfigManager().getOutboundConfig();
        boolean configured = data.isCallHomeServer() && data.isAllowPassthru() && super.isConfigured();
        Trace.trace(TRACE_MASKT, "<-> isConfigured() [" + configured + "]");
        return configured;
    }

    public boolean fail() {
        Trace.trace(TRACE_MASKT, "--> fail()");
        boolean fail = false;
        if (!this.failOver) {
            if (this.active) {
                this.deactivate();
            }
            this.failOver = true;
            fail = true;
        } else if (this.active) {
            this.deactivate();
        }
        Trace.trace(TRACE_MASKT, "<-- fail() [" + fail + "]");
        return fail;
    }
}

